/*
 * Copyright (C) 1990 by
 * Digital Equipment Corporation, Maynard, Massachusetts.
 * All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  of  the  terms  of  such  license  and with the
 * inclusion of the above copyright notice. This software or  any  other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 * The information in this software is  subject to change without notice
 * and  should  not  be  construed  as a commitment by Digital Equipment
 * Corporation.
 *
 * Digital assumes no responsibility for the use  or  reliability of its
 * software on equipment which is not supplied by Digital.
 *
 *
 * Abstract:	VGA Definitions
 *
 * Author:	John A. DeNisco
 *
 * Modifications:
 *
 *	jad	14-Sep-1993	Initial entry.
 */

#define VGAGSEG (0xA0000)    /*base address of the font tables on the vga option*/
#define VGAASEG (0xB8000)    /*base address of the visible screen memory */

/*---------register addresses --------------------                          */
#define MO_write 962                   /* Miscellaneous Output             */
#define MO_read 972
#define FC_write 986                    /* Feature Control                  */
#define FC_read 970
#define IS0 962                         /* Input Status #0                  */
#define IS1 986
#define SEQA 964                        /* Sequencer Registers base         */
#define SEQD 965                        /* Sequencer Registers base         */
#define CRTA 980                        /* CRT Controller Registers base    */
#define CRTD 981                        /* CRT Controller Registers base    */
#define GPHA 974                        /* Graphics Controller Registers base */
#define GPHD 975                        /* Graphics Controller Registers base */
#define ATTA 960                        /* Attribute Controller Registers base */
#define ATTD 960
#define DACW 968
#define DACR 967
#define DACD 969
#define DACM 966

/*--------- sequencer register indices --------------------                 */
#define SEQ_K_RESET 0
#define SEQ_K_CLK_MODE 1
#define SEQ_K_MAP_MSK 2
#define SEQ_K_CMSEL 3
#define SEQ_K_MEM_MODE 4

/*--------- CRT controller register indices --------------------            */
#define CRT_K_HT 0                      /* horizontal total                 */
#define CRT_K_HDE 1                     /* horizontal display end           */
#define CRT_K_SHB 2                     /* start horizontal blank           */
#define CRT_K_EHB 3                     /* end horizontal blank             */
#define CRT_K_SHR 4                     /* start horizontal retrace         */
#define CRT_K_EHR 5                     /* end  horizontal retrace          */
#define CRT_K_VT 6                      /* vertical total                   */
#define CRT_K_OF 7                      /* overflow                         */
#define CRT_K_PRS 8                     /* preset row scan                  */
#define CRT_K_MSL 9                     /* max scan line                    */
#define CRT_K_CS 10                     /* cursor start                     */
#define CRT_M_CO 20                     /* cursor off                       */
#define CRT_K_CE 11                     /* cursor end                       */
#define CRT_K_SAH 12                    /* start address high               */
#define CRT_K_SAL 13                    /* start address low                */
#define CRT_K_CLH 14                    /* cursor location high             */
#define CRT_K_CLL 15                    /* cursor location low              */
#define CRT_K_VRS 16                    /* vertical retrace start           */
#define CRT_K_VRL 17                    /* vertical retrace low             */
#define CRT_K_VDE 18                    /* vertical display end             */
#define CRT_K_OS 19                     /* offset                           */
#define CRT_K_UL 20                     /* underline location               */
#define CRT_K_SVB 21                    /* start vertical blank             */
#define CRT_K_EVB 22                    /* end vertical blank               */
#define CRT_K_MC 23                     /* mode control                     */
#define CRT_K_LC 24                     /* line compare                     */

/*--------- graphics controller register indices --------------------       */
#define GPH_K_SR 0                      /* set/reset                        */
#define GPH_K_ESR 1                     /* enable set/reset                 */
#define GPH_K_CC 2                      /* color compare                    */
#define GPH_K_DR 3                      /* data rotate                      */
#define GPH_K_RMS 4                     /* read map select                  */
#define GPH_K_MODE 5                    /* mode                             */
#define GPH_K_MISC 6                    /* miscellaneous                    */
#define GPH_K_CDC 7                     /* color don't care                 */
#define GPH_K_BITM 8                    /* bit mask                         */

/*--------- attribute controller register indices --------------------      */
#define ATT_K_MC 16                     /* mode control                     */
#define ATT_K_OC 17                     /* overscan color                   */
#define ATT_K_CPE 18                    /* color plane enable               */
#define ATT_K_HPP 19                    /* horizontal pixel panning         */
#define ATT_K_CS 20                     /* color select                     */

/* CRTC registers */
#define	NCINIT	25
char	vgacinit[NCINIT] = {
	0x5F,	0x4F,	0x50,	0x82,	0x55,
	0x81,	0xBF,	0x1F,	0x00,	0x4F,
	0x0d,	0x0e,	0x00,	0x00,	0x00,
	0x00,	0x9C,	0x8E,	0x8F,	0x28,
	0x1F,	0x96,	0xB9,	0xA3,	0xFF
};

/*Fonts*/

unsigned char	vga8x16xx[] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

unsigned char	vga8x16gl[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,	/* ! */
	0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,

	0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,	/* " */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x66, 0x66, 0xFF, 0xFF, 0x66, 0x66,	/* # */
	0xFF, 0xFF, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,

	0x18, 0x18, 0x3E, 0x7E, 0x60, 0x60, 0x7C, 0x3E,	/* $ */
	0x06, 0x06, 0x7E, 0x7C, 0x18, 0x18, 0x00, 0x00,

	0x00, 0x00, 0x66, 0x66, 0x6C, 0x0C, 0x18, 0x18,	/* % */
	0x30, 0x36, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,

	0x38, 0x7C, 0x6C, 0x6C, 0x38, 0x38, 0x70, 0x70,	/* & */
	0xDE, 0xDE, 0xCC, 0xCC, 0xFE, 0x76, 0x00, 0x00,

	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,	/* ' */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x06, 0x0C, 0x1C, 0x18, 0x18, 0x18,	/* ( */
	0x18, 0x18, 0x18, 0x1C, 0x0C, 0x06, 0x00, 0x00,

	0x00, 0x00, 0x60, 0x30, 0x38, 0x18, 0x18, 0x18,	/* ) */
	0x18, 0x18, 0x18, 0x38, 0x30, 0x60, 0x00, 0x00,

	0x00, 0x00, 0x66, 0x66, 0x3C, 0x3C, 0xFF, 0xFF,	/* * */
	0x3C, 0x3C, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x7E, 0x7E,	/* + */
	0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* , */
	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x30, 0x20,

	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x7E,	/* - */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* . */
	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,

	0x00, 0x00, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x18,	/* / */
	0x18, 0x30, 0x30, 0x60, 0x60, 0x60, 0x00, 0x00,

	0x00, 0x00, 0x1E, 0x3E, 0x66, 0x66, 0x66, 0x6E,	/* 0 */
	0x76, 0x66, 0x66, 0x66, 0x7c, 0x78, 0x00, 0x00,

	0x00, 0x00, 0x18, 0x18, 0x38, 0x38, 0x18, 0x18,	/* 1 */
	0x18, 0x18, 0x18, 0x18, 0x7E, 0x7E, 0x00, 0x00,

	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x0C, 0x0C,	/* 2 */
	0x18, 0x18, 0x30, 0x30, 0x7E, 0x7E, 0x00, 0x00,

	0x00, 0x00, 0x7E, 0x7E, 0x0C, 0x0C, 0x18, 0x18,	/* 3 */
	0x0C, 0x0C, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,

	0x00, 0x00, 0x0C, 0x0C, 0x1C, 0x1C, 0x3C, 0x3C,	/* 4 */
	0x6C, 0x6C, 0x7E, 0x7E, 0x0C, 0x0C, 0x00, 0x00,

	0x00, 0x00, 0x7E, 0x7E, 0x60, 0x60, 0x7C, 0x7E,	/* 5 */
	0x06, 0x06, 0x06, 0x66, 0x7E, 0x3C, 0x00, 0x00,

	0x00, 0x00, 0x1C, 0x3C, 0x70, 0x60, 0x60, 0x7C,	/* 6 */
	0x7E, 0x66, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,

	0x00, 0x00, 0x7E, 0x7E, 0x06, 0x06, 0x0C, 0x0C,	/* 7 */
	0x18, 0x18, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00,

	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x3C, 0x3C,	/* 8 */
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,

	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x7E, 0x3E,	/* 9 */
	0x06, 0x06, 0x06, 0x0E, 0x3C, 0x38, 0x00, 0x00,

	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,	/* : */
	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,

	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,	/* ; */
	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x30, 0x20,

	0x00, 0x00, 0x00, 0x0E, 0x1C, 0x38, 0x70, 0xE0,	/* < */
	0x70, 0x38, 0x1C, 0x0E, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x00, 0x00, 0x7E, 0x7E, 0x00, 0x00,	/* = */
	0x7E, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x00, 0xE0, 0x70, 0x38, 0x1C, 0x0E,	/* > */
	0x1C, 0x38, 0x70, 0xE0, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x0C, 0x0C,	/* ? */
	0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00,

	0x00, 0x00, 0x38, 0x7C, 0xE6, 0xC2, 0xDA, 0xD6,	/* @ */
	0xD6, 0xDC, 0xC0, 0xE2, 0x7E, 0x3C, 0x00, 0x00,

	0x00, 0x00, 0x18, 0x3C, 0x7E, 0x66, 0x66, 0x66,	/* A */
	0x7E, 0x7E, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,

	0x00, 0x00, 0x7C, 0x7E, 0x66, 0x66, 0x7E, 0x7C,	/* B */
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x7C, 0x00, 0x00,

	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x60, 0x60,	/* C */
	0x60, 0x60, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,

	0x00, 0x00, 0x78, 0x7C, 0x6E, 0x66, 0x66, 0x66,	/* D */
	0x66, 0x66, 0x66, 0x6E, 0x7C, 0x78, 0x00, 0x00,

	0x00, 0x00, 0x7E, 0x7E, 0x60, 0x60, 0x7C, 0x7C,	/* E */
	0x60, 0x60, 0x60, 0x60, 0x7E, 0x7E, 0x00, 0x00,

	0x00, 0x00, 0x7E, 0x7E, 0x60, 0x60, 0x7C, 0x7C,	/* F */
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00,

	0x00, 0x00, 0x3E, 0x7E, 0x60, 0x60, 0x6E, 0x6E,	/* G */
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,

	0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x7E, 0x7E,	/* H */
	0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,

	0x00, 0x00, 0x7E, 0x7E, 0x18, 0x18, 0x18, 0x18,	/* I */
	0x18, 0x18, 0x18, 0x18, 0x7E, 0x7E, 0x00, 0x00,

	0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,	/* J */
	0x06, 0x06, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,

	0x00, 0x00, 0xCC, 0xCC, 0xD8, 0xD8, 0xF0, 0xF0,	/* K */
	0xD8, 0xD8, 0xCC, 0xCC, 0xC6, 0xC6, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,	/* L */
	0x60, 0x60, 0x60, 0x60, 0x7E, 0x7E, 0x00, 0x00,
	0x00, 0x00, 0xC6, 0xC6, 0xEE, 0xEE, 0xFE, 0xD6,	/* M */
	0xD6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x76, 0x76, 0x7E,	/* N */
	0x7E, 0x6E, 0x6E, 0x66, 0x66, 0x66, 0x00, 0x00,
	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x66, 0x66,	/* O */
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x7C, 0x7E, 0x66, 0x66, 0x66, 0x66,	/* P */
	0x7E, 0x7C, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00,
	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x66, 0x66,	/* Q */
	0x66, 0x66, 0x66, 0x6A, 0x7C, 0x36, 0x00, 0x00,
	0x00, 0x00, 0xF8, 0xFC, 0xCC, 0xCC, 0xCC, 0xFC,	/* R */
	0xF8, 0xD8, 0xCC, 0xCC, 0xC6, 0xC6, 0x00, 0x00,
	0x00, 0x00, 0x3E, 0x7E, 0x60, 0x60, 0x70, 0x38,	/* S */
	0x1C, 0x0E, 0x06, 0x06, 0x7E, 0x7C, 0x00, 0x00,
	0x00, 0x00, 0x7E, 0x7E, 0x18, 0x18, 0x18, 0x18,	/* T */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,	/* U */
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,	/* V */
	0x66, 0x66, 0x3C, 0x3C, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xD6,	/* W */
	0xD6, 0xFE, 0xFE, 0xEE, 0xC6, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x3C, 0x3C, 0x18,	/* X */
	0x18, 0x3C, 0x3C, 0x66, 0x66, 0x66, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x3C,	/* Y */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x7E, 0x7E, 0x0C, 0x0C, 0x18, 0x18,	/* Z */
	0x30, 0x30, 0x60, 0x60, 0x7E, 0x7E, 0x00, 0x00,

	0x00, 0x00, 0x1E, 0x1E, 0x18, 0x18, 0x18, 0x18,	/* [ */
	0x18, 0x18, 0x18, 0x18, 0x1E, 0x1E, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x60, 0x60, 0x30, 0x30, 0x18,	/* \ */
	0x18, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x78, 0x78, 0x18, 0x18, 0x18, 0x18,	/* ] */
	0x18, 0x18, 0x18, 0x18, 0x78, 0x78, 0x00, 0x00,
	0x00, 0x10, 0x10, 0x38, 0x38, 0x6C, 0x6C, 0xC6,	/* ^ */
	0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* _ */
	0x00, 0x00, 0x00, 0x00, 0xFE, 0xFE, 0x00, 0x00,
	0x40, 0x60, 0x70, 0x38, 0x1C, 0x0C, 0x04, 0x00,	/* ` */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x3E, 0x06,	/* a */
	0x3E, 0x7E, 0x66, 0x66, 0x7E, 0x3E, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x60, 0x60, 0x7C, 0x7E, 0x66,	/* b */
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x7C, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x7E, 0x60,	/* c */
	0x60, 0x60, 0x60, 0x60, 0x7E, 0x3E, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x06, 0x06, 0x3E, 0x7E, 0x66,	/* d */
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x3E, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x7E, 0x66,	/* e */
	0x66, 0x7E, 0x60, 0x60, 0x7E, 0x3E, 0x00, 0x00,
	0x00, 0x00, 0x0E, 0x1E, 0x18, 0x18, 0x7E, 0x7E,	/* f */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x7E, 0x66,	/* g */
	0x66, 0x66, 0x66, 0x7E, 0x3E, 0x06, 0x7E, 0x7C,
	0x00, 0x00, 0x60, 0x60, 0x60, 0x7C, 0x7E, 0x66,	/* h */
	0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x38, 0x18,	/* i */
	0x18, 0x18, 0x18, 0x18, 0x3C, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x0C, 0x0C, 0x00, 0x0C, 0x0C, 0x0C,	/* j */
	0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x7C, 0x78,
	0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xCC, 0xDC, 0xF8,	/* k */
	0xF0, 0xF8, 0xD8, 0xCC, 0xCE, 0xC6, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18,	/* l */
	0x18, 0x18, 0x18, 0x18, 0x3C, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0xFE, 0xFE,	/* m */
	0xD6, 0xD6, 0xD6, 0xC6, 0xC6, 0xC6, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x7E, 0x66,	/* n */
	0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x7E, 0x66,	/* o */
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x7E, 0x66,	/* p */
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x7C, 0x60, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x7E, 0x66,	/* q */
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x3E, 0x06, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x7E, 0x66,	/* r */
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7E, 0x60,	/* s */
	0x70, 0x3C, 0x0E, 0x06, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0x18, 0x7E, 0x7E, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x1E, 0x0E, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66,
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x3E, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66,
	0x66, 0x66, 0x3C, 0x3C, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xD6,
	0xD6, 0xFE, 0xFE, 0xEE, 0xC6, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x3C,
	0x3C, 0x18, 0x3C, 0x3C, 0x66, 0x66, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66,
	0x66, 0x66, 0x66, 0x7E, 0x3E, 0x06, 0x7E, 0x7C,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x7E, 0x0C,
	0x18, 0x18, 0x30, 0x30, 0x7E, 0x7E, 0x00, 0x00,
	0x00, 0x0E, 0x18, 0x18, 0x18, 0x18, 0x38, 0xF0,
	0xF0, 0x38, 0x18, 0x18, 0x18, 0x18, 0x0E, 0x00,
	0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00,
	0x00, 0xE0, 0x30, 0x30, 0x30, 0x30, 0x38, 0x1E,
	0x1E, 0x38, 0x30, 0x30, 0x30, 0x30, 0xE0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xF2, 0xBE,
	0x9C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/*The following definitions are taken from jnsvdeo.h*/

/* Define video controller parameters.*/

/* Define VGA registers.  This starts at ISA space 0x3C0.*/

typedef struct _VGA_READ_REGISTERS {
  UCHAR reserved0;
  UCHAR attribute_adddata;	/* 3c1*/
  UCHAR input_status_0;		/* 3c2*/
  UCHAR reserved1;
  UCHAR sequencer_address;	/* 3c4*/
  UCHAR sequencer_data;		/* 3c5*/
  UCHAR pel_mask;		/* 3c6*/
  UCHAR dac_state;		/* 3c7*/
  UCHAR pel_address_write_mode;	/* 3c8*/
  UCHAR pel_data;		/* 3c9*/
  UCHAR feature_control;	/* 3ca*/
  UCHAR reserved2;
  UCHAR misc_output;		/* 3cc*/
  UCHAR reserved3;
  UCHAR graphics_address;	/* 3ce*/
  UCHAR graphics_data;		/* 3cf*/
  UCHAR reserved4[4];
  UCHAR crtc_address;		/* 3d4*/
  UCHAR crtc_data;		/* 3d5*/
  UCHAR reserved5[4];
  UCHAR input_status_1;		/* 3da*/
} VGA_READ_REGISTERS, *PVGA_READ_REGISTERS;


typedef struct _VGA_WRITE_REGISTERS {
  UCHAR attribute_adddata;	/* 3c0*/
  UCHAR reserved0;
  UCHAR misc_output;		/* 3c2*/
  UCHAR reserved1;
  UCHAR sequencer_address;	/* 3c4*/
  UCHAR sequencer_data;		/* 3c5*/
  UCHAR pel_mask;		/* 3c6*/
  UCHAR pel_address_read_mode;	/* 3c7*/
  UCHAR pel_address_write_mode;	/* 3c8*/
  UCHAR pel_data;		/* 3c9*/
  UCHAR reserved2[4];
  UCHAR graphics_address;	/* 3ce*/
  UCHAR graphics_data;		/* 3cf*/
  UCHAR reserved3[4];
  UCHAR crtc_address;		/* 3d4*/
  UCHAR crtc_data;		/* 3d5*/
  UCHAR reserved[4];
  UCHAR feature_control;	/* 3da*/
} VGA_WRITE_REGISTERS, *PVGA_WRITE_REGISTERS;

/* Define indices*/

/* Sequencer register indices*/
#define VGA_RESET		0
#define VGA_CLOCKING_MODE	1
#define VGA_MAP_MASK		2
#define VGA_CHAR_MAP_SELECT	3
#define VGA_MEMORY_MODE		4

/* CRT controller register indices*/
#define VGA_HORIZONTAL_TOTAL		0
#define VGA_HORIZONTAL_DISPLAY_END	1
#define VGA_START_HORIZONTAL_BLANKING	2
#define VGA_END_HORIZONTAL_BLANKING	3
#define VGA_START_HORIZONTAL_RETRACE	4
#define VGA_END_HORIZONTAL_RETRACE	5
#define VGA_VERTICAL_TOTAL		6
#define VGA_OVERFLOW			7
#define VGA_PRESET_ROW_SCAN		8
#define VGA_MAXIMUM_SCAN_LINE		9
#define VGA_CURSOR_START		0xa
#define VGA_CURSOR_END			0xb
#define VGA_START_ADDRESS_HIGH		0xc
#define VGA_START_ADDRESS_LOW		0xd
#define VGA_CURSOR_LOCATION_HIGH	0xe
#define VGA_CURSOR_LOCATION_LOW		0xf
#define VGA_VERTICAL_RETRACE_START	0x10
#define VGA_VERTICAL_RETRACE_END	0x11
#define VGA_VERTICAL_DISPLAY_END	0x12
#define VGA_OFFSET			0x13
#define VGA_UNDERLINE_LOCATION		0x14
#define VGA_START_VERTICAL_BLANK	0x15
#define VGA_END_VERTICAL_BLANK		0x16
#define VGA_MODE_CONTROL		0x17
#define VGA_LINE_COMPARE		0x18

/* Non-standard VGA defines for the S3 911, 924, 928 chips*/
#define VGA_S3924_S3R0			0x30
#define VGA_S3924_S3R1			0x31
#define VGA_S3924_S3R2			0x32
#define VGA_S3924_S3R3			0x33
#define VGA_S3924_S3R4			0x34
#define VGA_S3924_S3R5			0x35
#define VGA_S3924_S3R8			0x38
#define VGA_S3924_S3R9			0x39
#define VGA_S3924_S3RA			0x3A
#define VGA_S3924_S3RB			0x3B
#define VGA_S3924_S3RC			0x3C
#define VGA_S3924_SC0			0x40
#define VGA_S3924_SC2			0x42
#define VGA_S3924_SC3			0x43
#define VGA_S3924_SC5			0x45

#define VGA_S3928_CR50			0x50
#define VGA_S3928_CR51			0x51
#define VGA_S3928_CR52			0x52
#define VGA_S3928_CR53			0x53
#define VGA_S3928_CR54			0x54
#define VGA_S3928_CR55			0x55
#define VGA_S3928_CR56			0x56
#define VGA_S3928_CR57			0x57
#define VGA_S3928_CR58			0x58
#define VGA_S3928_CR59			0x59
#define VGA_S3928_CR5A			0x5A
#define VGA_S3928_CR5B			0x5B
#define VGA_S3928_CR5C			0x5C
#define VGA_S3928_CR5D			0x5D
#define VGA_S3928_CR5E			0x5E
#define VGA_S3928_CR5F			0x5F
#define VGA_S3928_CR60			0x60
#define VGA_S3928_CR61			0x62
#define VGA_S3928_CR62			0x61

/* Graphics controller register indices*/
#define VGA_SET_RESET			0
#define VGA_ENABLE_SET_RESET		1
#define VGA_COLOR_COMPARE		2
#define VGA_DATA_ROTATE			3
#define VGA_READ_MAP_SELECT		4
#define VGA_MODE			5
#define VGA_MISCELLANEOUS		6
#define VGA_COLOR_DONT_CARE		7
#define VGA_BIT_MASK			8

/* Attribute controller register indices*/
#define VGA_PALETTE0			0
#define VGA_PALETTE1			1
#define VGA_PALETTE2			2
#define VGA_PALETTE3			3
#define VGA_PALETTE4			4
#define VGA_PALETTE5			5
#define VGA_PALETTE6			6
#define VGA_PALETTE7			7
#define VGA_PALETTE8			8
#define VGA_PALETTE9			9
#define VGA_PALETTEA			0xa
#define VGA_PALETTEB			0xb
#define VGA_PALETTEC			0xc
#define VGA_PALETTED			0xd
#define VGA_PALETTEE			0xe
#define VGA_PALETTEF			0xf
#define VGA_ATTR_MODE_CONTROL		0x10
#define VGA_OVERSCAN			0x11
#define VGA_COLOR_PLANE_ENABLE		0x12
#define VGA_HORIZONTAL_PIXEL_PANNING	0x13
#define VGA_COLOR_SELECT		0x14
#define VGA_SET_PAS 			0x20


/**/
/* Define colors, HI = High Intensity*/
/**/
/* The palette registers are simply 1:1 indirections to the color registers.*/
/**/
/**/

#define FW_COLOR_BLACK      0x00
#define FW_COLOR_RED        0x01
#define FW_COLOR_GREEN      0x02
#define FW_COLOR_YELLOW     0x03
#define FW_COLOR_BLUE       0x04
#define FW_COLOR_MAGENTA    0x05
#define FW_COLOR_CYAN       0x06
#define FW_COLOR_WHITE      0x07
#define FW_COLOR_HI_BLACK   0x08
#define FW_COLOR_HI_RED     0x09
#define FW_COLOR_HI_GREEN   0x0A
#define FW_COLOR_HI_YELLOW  0x0B
#define FW_COLOR_HI_BLUE    0x0C
#define FW_COLOR_HI_MAGENTA 0x0D
#define FW_COLOR_HI_CYAN    0x0E
#define FW_COLOR_HI_WHITE   0x0F

#define PALETTE_BLACK      0x00
#define PALETTE_RED        0x01
#define PALETTE_GREEN      0x02
#define PALETTE_YELLOW     0x03
#define PALETTE_BLUE       0x04
#define PALETTE_MAGENTA    0x05
#define PALETTE_CYAN       0x06
#define PALETTE_WHITE      0x07
#define PALETTE_HI_BLACK   0x08
#define PALETTE_HI_RED     0x09
#define PALETTE_HI_GREEN   0x0a
#define PALETTE_HI_YELLOW  0x0b
#define PALETTE_HI_BLUE    0x0c
#define PALETTE_HI_MAGENTA 0x0d
#define PALETTE_HI_CYAN    0x0e
#define PALETTE_HI_WHITE   0x0f

#define COLOR_REGISTER_BLACK_R      0x00
#define COLOR_REGISTER_BLACK_G      0x00
#define COLOR_REGISTER_BLACK_B      0x00

#define COLOR_REGISTER_RED_R        0x2A
#define COLOR_REGISTER_RED_G        0x00
#define COLOR_REGISTER_RED_B        0x00

#define COLOR_REGISTER_GREEN_R      0x00
#define COLOR_REGISTER_GREEN_G      0x2A
#define COLOR_REGISTER_GREEN_B      0x00

#define COLOR_REGISTER_YELLOW_R     0x2a
#define COLOR_REGISTER_YELLOW_G     0x2a
#define COLOR_REGISTER_YELLOW_B     0x00

#define COLOR_REGISTER_BLUE_R       0x00
#define COLOR_REGISTER_BLUE_G       0x00
#define COLOR_REGISTER_BLUE_B       0x2a

#define COLOR_REGISTER_MAGENTA_R    0x2a
#define COLOR_REGISTER_MAGENTA_G    0x00
#define COLOR_REGISTER_MAGENTA_B    0x2a

#define COLOR_REGISTER_CYAN_R       0x00
#define COLOR_REGISTER_CYAN_G       0x2a
#define COLOR_REGISTER_CYAN_B       0x2a

#define COLOR_REGISTER_WHITE_R      0x2a
#define COLOR_REGISTER_WHITE_G      0x2a
#define COLOR_REGISTER_WHITE_B      0x2a

#define COLOR_REGISTER_HI_BLACK_R   0x00
#define COLOR_REGISTER_HI_BLACK_G   0x00
#define COLOR_REGISTER_HI_BLACK_B   0x00

#define COLOR_REGISTER_HI_RED_R     0x3f
#define COLOR_REGISTER_HI_RED_G     0x00
#define COLOR_REGISTER_HI_RED_B     0x00

#define COLOR_REGISTER_HI_GREEN_R   0x00
#define COLOR_REGISTER_HI_GREEN_G   0x3f
#define COLOR_REGISTER_HI_GREEN_B   0x00

#define COLOR_REGISTER_HI_YELLOW_R  0x3f
#define COLOR_REGISTER_HI_YELLOW_G  0x3f
#define COLOR_REGISTER_HI_YELLOW_B  0x00

#define COLOR_REGISTER_HI_BLUE_R    0x00
#define COLOR_REGISTER_HI_BLUE_G    0x00
#define COLOR_REGISTER_HI_BLUE_B    0x3f

#define COLOR_REGISTER_HI_MAGENTA_R 0x3f
#define COLOR_REGISTER_HI_MAGENTA_G 0x00
#define COLOR_REGISTER_HI_MAGENTA_B 0x3f

#define COLOR_REGISTER_HI_CYAN_R    0x00
#define COLOR_REGISTER_HI_CYAN_G    0x3f
#define COLOR_REGISTER_HI_CYAN_B    0x3f

#define COLOR_REGISTER_HI_WHITE_R   0x3f
#define COLOR_REGISTER_HI_WHITE_G   0x3f
#define COLOR_REGISTER_HI_WHITE_B   0x3f

/* Define virtual address of the video memory and control registers.*/

#define VIDEO_CONTROL_BASE 0x03c0
#define VIDEO_CONTROL_READ	( (volatile PVGA_READ_REGISTERS)VIDEO_CONTROL_BASE )
#define VIDEO_CONTROL_WRITE	( (volatile PVGA_WRITE_REGISTERS)VIDEO_CONTROL_BASE )

/* stuff for setting #9 memory clock frequency */

#define FORTY_MHZ		40000000
#define FORTY_MHZ_MAGIC_NUM	0xe2e140
#define CRYSTAL_FREQUENCY       (14318180 * 2)
#define MIN_VCO_FREQUENCY       50000000
#define MAX_POST_SCALE          285000000
#define MAX_NUMERATOR           130
#define MAX_DENOMINATOR         umin(129, CRYSTAL_FREQUENCY / 400000)
#define MIN_DENOMINATOR         umax(3, CRYSTAL_FREQUENCY / 2000000)
#define C_DATA  2
#define C_CLK   1
#define C_BOTH  3
#define C_NONE  0
#define LOCK_INDEX              0x39
#define UNLOCK_PATTERN          0xA0
#define SSW_WRITE_INDEX         0x5C
#define MODE_CTRL_INDEX         0x42



/*									*/
/* Graphics cards are initialized though a video initialization table.	*/
/* The initialization function starts at the beginning of the table	*/
/* and interprets each entry, until the end of the table.  Each entry describes*/
/* one operation (an I/O space access or a function to be performed).	*/
/*  									*/
/* A simplifying assumption is that NT/Alpha will boot using VGA mode graphics.*/
/* Hence, most of the initialization work should be identical across all*/
/* bootable cards.							*/
/*  									*/
/* Fields in each entry:						*/
/*  									*/
/* DoIf - Perform the operation in this entry only if the card is one of the*/
/*  	  types in this mask field.  One bit per card.			*/
/*									*/
/* MB - TRUE = Execute a Memory Barrier (MB) instruction after this entry.*/
/*  									*/
/* Operation - Indicates the operation to be performed.  This is an	*/
/*  	       I/O space read or write, a special function to be called, etc.*/
/*             Note: The results of I/O space reads are discarded.	*/
/*  									*/
/* Size - The size of the operation, if needed: UCHAR, USHORT, or ULONG.*/
/*  									*/
/* Address - The address for the operation, if needed.			*/
/*  									*/
/* WriteValue - The constant value to be written on an I/O space write.	*/
/*  									*/
/*  									*/
/* The cards supported are:						*/
/*  									*/
/* - Paradise board with a Western Digital 90C11 chipset.  SVGA,	*/
/*   non-accelerated.  ISA card.					*/
/*  									*/
/* - Compaq QVision-family boards.  SVGA, accelerated, EISA card.  Compaq*/
/*   chipset is a clone of a member of the WD90Cxx family.  Specific boards*/
/*   supported are the QVision 1024/E and the Orion 1280/E.		*/
/*									*/
/* - Cardinal board with S3 924 chip (Cardinal name is VGA900, DEC name is*/
/*   PCXAG-AG).  SVGA, ISA card.					*/
/*									*/
/* - Number Nine GXE with an S3 928 chip. 				*/
/*									*/
/* - ATI Graphics UltraPro Mach32, but only at power-up.		*/
/*   The Jensen VMS/OSF console is not supporting it, so work on this board*/
/*   has been halted.							*/
/*									*/
/*									*/
/* Cards specifically not supported:					*/
/*									*/
/* - ATI embedded graphics subsystem in the Morgan machine.		*/
/*									*/

/* Define Video Initialization Table field types*/
/* Encodings for the DoIf field.*/

/* These constants define each of the Alpha/Jensen supported video cards.*/
/* For code compaction, only a byte is used.  If the DoIf field is widened,*/
/* widen AllCards too.							*/

/* HACK: There are parallel definitions in fw\alpha\fwp.h.		*/

#define	Paradise_WD90C11		0x1
#define QVision				0x2
#define Cardinal_S3_924			0x4
#define S3_928				0x8
#define ATI_Graphics_UltraPro_Mach32	0x10
#define	Burns_WD90C24			0x20
#define AllCards			0xff

/* Encodings for the Operation field.*/

typedef enum _VIT_OPERATION {
	None,
	Read,
	Write,
	LoadFonts,
	InitializeNumber9Clocks,
	ATIMiscOptions,
	ATIAperature,
	ATIDAC,
 	End_Of_Initialization		/* Reserved for last table entry.*/
} VIT_OPERATION, *PVIT_OPERATION;

/* Encodings for the Size field.*/

typedef enum _VIT_SIZE {
	UChar,
	UShort,
	ULong
} VIT_SIZE, *PVIT_SIZE;

/* Define the Video Initialization Table type.  12 bytes per entry.*/

typedef struct _VIDEO_INITIALIZATION_TABLE {
	UCHAR DoIf;
	BOOLEAN MB;
	UCHAR Operation;
	UCHAR Size;
	PUCHAR Address;
	ULONG WriteValue;
} VIDEO_INITIALIZATION_TABLE, *PVIDEO_INITIALIZATION_TABLE;

/*									*/
/* Define the macros for building the video initialization table.	*/
/* As a simplification, every macro automatically sets the MB bit.	*/

/* Do an operation with no arguments.*/
#define _VIT_Function(FunctionToCall) \
	{ AllCards, TRUE, FunctionToCall, 0, NULL, 0 }

/* Do an operation with no arguments, only for certain cards.*/
#define _VIT_FunctionIf(Mask, FunctionToCall) \
	{ Mask, TRUE, FunctionToCall, 0, NULL, 0 }

/* Do a read operation.*/
#define _VIT_Read(Size, Address) \
	{ AllCards, TRUE, Read, Size, (PUCHAR)Address, 0 }

/* Do a write operation.*/
#define _VIT_Write(Size, Address, Value) \
	{ AllCards, TRUE, Write, Size, (PUCHAR)Address, Value }

/* Do a read operation only for certain cards.*/
#define _VIT_ReadIf(Mask, Size, Address) \
	{ Mask, TRUE, Read, Size, (PUCHAR)Address, 0 }

/* Do a write operation only for certain cards.*/
#define _VIT_WriteIf(Mask, Size, Address, Value) \
	{ Mask, TRUE, Write, Size, (PUCHAR)Address, Value }
